/*
	File: CEG_init.sqf
	Version: 1.1
	Author: Loyalguard
 
	Description:
	A script to initialize required data and launch other scripts necessary for the CEG simulation. 

	Parameters:
	_this select 0: Type of executing instance (string).
 
	Execution:
	Executed by a CEG Logic, Addon XEH,  or other similar executing instance.  This script will run on all machines SP, MP Hosts, MP dedicated servers, and MP Clients).  If CEG has already been initialized (by a previous instance of this script) then subsequent instances will abort to avoid conflicts.  This could occur if a mission maker implemented the script version of CEG in the mission and the player has the CEG addon version also installed.   Since the script version is executed by placing a CEG logic in the editor and the addon version is executed by a PostInit XEH, the script version will execute BEFORE the addon version since mission.sqm init line code runs before PostInit XEHs.
 */
 
// Scope //
private ["_type"];

// Parameter(s) //
_type = (_this select 0);
 
if (!isNil "CEG_DEBUG") then {_debug = ["CEG_init.sqf: Thread started."] call LGD_fnc_debugMessage;}; //DEBUG

// Check to see if the machine is a JIP MP client and store the result in the global variable CEG_JIP.  Evaluate it later in CEG_client.sqf if the machine is a MP client.

if (isMultiplayer) then
{
	if ((!isDedicated) and (isNull player)) then
	{
		CEG_JIP = true;
	}
	else
	{
		CEG_JIP = false;
	};
	if (!isNil "CEG_DEBUG") then {_debug = ["CEG_init.sqf: MP JIP check completed. CEG_JIP =", CEG_JIP] call LGD_fnc_debugMessage;}; //DEBUG
}
else
{
	if (!isNil "CEG_DEBUG") then {_debug = ["CEG_init.sqf: SP Detected - MP JIP check skipped."] call LGD_fnc_debugMessage;}; //DEBUG
};

// If CEG has already been initialized (by a previous instance of this script) then abort to avoid conflicts. 

if (_type == "SCRIPT") then {diag_log text "CEG Script init started...";};
if (_type == "ADDON") then {diag_log text "CEG: Addon init started..."; sleep .01};
if (!isNil ("CEG_init")) exitWith {diag_log text format ["CEG: CEG %1 version is already initialized...aborting %2 version.", CEG_type, _type];};

// Record that CEG_init.sqf has been executed, the type of executing instance (MISSION or ADDON), and the version number.
CEG_init = true;
CEG_type = _type;
CEG_version = 1.1;

// If the currently loaded world is NOT Chernarus then abort CEG as it will only function on Chernarus.
if (worldName != "Chernarus") exitWith {diag_log text "CEG: The current mission is not on Chernarus, CEG will only function on Chernarus...aborting CEG for this mission only."};

// If this is SP or a server then validate that CEG is installed and initializing on the server.
if (isServer) then
{
	CEG_server = true;
	publicVariable "CEG_server";
};

// If CEG is NOT installed and initializing/initialized on the server then exit immediately since CEG will not function in MP without server components.
sleep 2; // Wait to ensure PV from server is broadcasted.
if (isNil ("CEG_Server")) exitWith {diag_log text "CEG: CEG must be installed on the server to function...aborting CEG client."};

/* Create a global array to store information necessary to create all the different objects and logical components required by the CEG simulation.  The array elements are as follows:

	["objectType_location", [Object Position Subarray], "ClassName", addAction?, "EffectType", [Supplied Nodes Subarray]]
*/
CEG_objects =
[	
	["D_Bere", [12857.9,9872.9,0], "Land_trafostanica_velka", true, "XFMR", []],
	["T_Zele_1", [2256.56,5257.14,0], "Land_trafostanica_velka", true, "XFMR", [["D_Zele", .5], ["T_Zele_2", .5]]],
	["T_Zele_2", [2254.26,5236.21,0], "Land_trafostanica_velka", true, "XFMR", [["D_Bere", 1]]],
	["D_Zele", [2286.14,5247.76,0], "Land_trafostanica_velka", true, "XFMR", [["T_Zele_2", .5]]],
	["T_Cher_1", [6225.57,2163.83,-2.28], "Land_trafostanica_velka", true, "XFMR", [["T_SZag_2", 1], ["D_Cher", .5]]],
	["D_Cher", [6248.39,2467.36,6.67], "Land_trafostanica_velka", true, "XFMR", []],
	["S_Cher", [6263.8643,2206.2778,27], "Land_Ind_MalyKomin", false, "SMOKE", []],
	["P_Cher", [6249.57,2188.1,0], "Land_Ind_Pec_03a", false, "PLANT", [["S_Cher", 1], ["T_Cher_1", 1]]],
	["T_SZag_3", [5669.14,2986.78,0], "Land_trafostanica_velka", true, "XFMR", [["T_Zele_1", 1]]],
	["T_SZag_2", [5680.46,2948.25,0], "Land_trafostanica_velka", true, "XFMR", [["T_SZag_3", .5], ["D_SZag", .5]]] ,
	["T_SZag_1", [5680.74,2984.81,7.6], "Land_trafostanica_velka", true, "XFMR", [["D_SZag", .5], ["T_SZag_3", .5]]],
	["D_SZag", [5687.86,2960.26,-2.28], "Land_trafostanica_velka", true, "XFMR", [["D_Cher", .5]]],
	["D_Soln", [12782.1,6209.95,1.7], "Land_trafostanica_velka", true, "XFMR", []],
	["D_Elek", [10452.6,2649.76,4.7], "Land_trafostanica_velka", true, "XFMR", [["D_Soln", 1]]],
	["T_Elek_2", [10472,2620.67,8.10], "Land_trafostanica_velka", true, "XFMR", [["D_Zele", .5]]],
	["T_Elek_1", [10466.8,2611.02,0], "Land_trafostanica_velka", true, "XFMR", [["T_SZag_1", 1]]],
	["S_Elek", [10411.19,2599.3613,55], "Land_Ind_Stack_Big", false, "SMOKE", []],
	["P_Elek", [10438.6,2600.89,0], "Land_Ind_Pec_03a", false, "PLANT", [["S_Elek", 1], ["T_Elek_1", 1], ["T_Elek_2", 1], ["D_Elek", 1]]]
];

// Add a public variable event handler to all machines the will fire when an arc flash explosion should occur as determined in CEG_actions.sqf
"CEG_arc" addPublicVariableEventHandler {[(_this select 1)] execVM "CEG\Scripts\CEG_flash.sqf";};

// If the machine is singleplayer, a MP host, or a MP dedicated server then execute CEG_server.sqf.  Otherwise it is a MP client and execute CEG_client.sqf.
if (isServer) then 
{
	_nul = [] execVM "CEG\Scripts\CEG_server.sqf";
}
else
{
	_nul = [] execVM "CEG\Scripts\CEG_client.sqf";
};

if (!isNil "CEG_DEBUG") then {_debug = ["CEG_init.sqf: Thread finished."] call LGD_fnc_debugMessage;}; //DEBUG